#!/bin/bash

if [ -z "$1" ]; then
	echo "Usage: $0 <DOC file name>" >&2
	exit 1
fi


if [ -f "$1" ]; then
	strings "$1" |sed 's/\^//g' |sed 's/&&/\n/g' >/tmp/unravel.$$
else
	echo "Couldn't find file specified: $1" >&2
	exit 1
fi

trap "if [ -f /tmp/unravel.$$ ]; then rm /tmp/unravel.$$; fi" EXIT SIGTERM

varname="$(strings "$1" |sed 's/\^//g' |sed 's/&&/\n/g' |grep -m1 -e ^call)"
varname="${varname%%'='*}"
varname="${varname##*' '}"

if [ -z "$varname" ]; then
	echo -e "Sorry the file \"$1\" does not contain the expected malware" >&2
	exit 1
fi


obfuscated="$(grep -Fm1 "set $varname" /tmp/unravel.$$)"
obfuscated="${obfuscated#*"$varname="}"

plain=""

while [ "${#obfuscated}" -gt 0 ];
do
	if [ "${obfuscated:0:1}" == '%' ]; then
		# Lookup var value
		obfuscated="${obfuscated:1}"
		value="$(grep -Fm1 "set ${obfuscated%%'%'*}" /tmp/unravel.$$)"
		value="${value#*'='}"
		if [ -n "$value" ]; then
			plain+="$value"
		fi
		obfuscated="${obfuscated#*'%'}"
		
	else
		# Append literal
		plain+="${obfuscated%%'%'*}"
		obfuscated="%${obfuscated#*'%'}"
	fi

done

urls="$(echo "$plain"  |sed 's/;/;\n/g' |grep -m1 Split)"
urls="${urls#*"'"}"
urls="${urls%%"'"*}"

while [ "${urls//@}" != "$urls" ];
do
	echo "${urls%%'@'*}"
	urls="${urls#*'@'}"
done
