#!/bin/bash

i=0
while read -t1 line
do
	name_part1[$i]="${line%' '*}"
	name_part2[$i]="${line##*' '}"
	((++i))
done
unset i

if [ -z "${name_part1[0]}" ] && [ "${#name_part1[@]}" == "1" ]; then
	echo -e "\nUsage: [ pipe | ] $0 [ < stdin ]"
	echo -e "\nExamples:"
	echo -e "\t$0 < names.txt"
	echo -e "\t\t - or -"
	echo -e "\tcat names.txt | $0"
	echo -e "\nScript requires an input stream!\n"
	exit 1
fi
	

get_names() {
	echo "-fill black -pointsize 14"
	i=0

	# Two maintain alphabetical order vertically rather
	# than horizontal + vertically we put the draw
	# statements into two different loops to process
	# all of one side of the card first

	# Left side of card
	while [ "$i" -lt "14" ]
	do
		# adjust placement for bottom half
		if [ "$i" -lt "8" ]; then
			y1=20
			y2=34
		else
			y1=16
			y2=30
		fi
		echo -e "-draw \"text 8,$(($y1 + 43 * $i))  '${name_part1[$i]}'\""
		echo -e "-draw \"text 8,$(($y2 + 43 * $i))  '${name_part2[$i]}'\""
		((i++))

	done
	# Right side of card
	while [ "$i" -lt "28" ]
	do
		# adjust placement for bottom half
		if [ "$i" -lt "15" ]; then
			y1=20
			y2=34
		else
			y1=16
			y2=30
		fi
		echo -e "-draw \"text 103,$(($y1 + 43 * $((i - 14)))) '${name_part1[$i]}'\""
		echo -e "-draw \"text 103,$(($y2 + 43 * $((i - 14)))) '${name_part2[$i]}'\""
		((i++))

	done
}

offset() {
	skew="$1"
	((skew--))
	skew="$((skew * 10))"
	skew="$((skew * 5 / 10))"

	if [ "${skew: -1:1}" == "5" ]; then
		skew="$((skew+ 10))"
	fi

	skew="${skew:0:1}"

	echo "$skew"
}

draw_box() {
	echo "-fill none -strokewidth 2 -stroke black "
	echo "-draw 'stroke-dasharray 5 3  rectangle 1,1,187,595' "
	echo "-fill none -strokewidth 1 -stroke black "
	echo "-draw 'line 95,0 95,609' "
	row=1
	while [ "$row" -le "13" ];
	do
		echo "-draw 'line 0,$((43 * $row - $(offset $row) )) 190,$((43 * $row - $(offset $row) ))' "
		((++row))
	done
}


# Generate left template
bash -c "$(echo convert -size 189x597 xc:white $(get_names) $(draw_box) template1.png)" 

# shift remaining names down the array
if [ "${#name_part1[@]}" -gt "27" ]; then
	i=0
	while [ "$i" -le "27" ]
	do
		name_part1[$i]="${name_part1[$((i + 28))]}"
		name_part2[$i]="${name_part2[$((i + 28))]}"
		((i++))
	done
fi

# Generate right template
bash -c "$(echo convert -size 189x597 xc:white $(get_names) $(draw_box) template2.png)" 


# side by side on one peice of paper
#montage -units PixelsPerInch -density 96 template?.png -mode concatenate -tile 2x template.pdf

# Or one per page
convert -units PixelsPerInch -density 96 template?.png template.pdf

if [ -f "template.pdf" ]; then
	rm template1.png template2.png
fi

