#!/bin/bash
source luhn.sh


# Example IMEI number from Wikipedia
sample_imei="352152097374972"
if luhn_test "$sample_imei"; then
	echo "$sample_imei might be a valid IMEI"
else
	echo "$sample_imei is an invalid IMEI"
fi

# Same number with the last two digits transposed
sample_imei="352152097374927"
if luhn_test "$sample_imei"; then
	echo "$sample_imei might be a valid IMEI"
else
	echo "$sample_imei is an invalid IMEI"
fi

# Creating a check digit for a set of numbers
echo "35215209737497 would be a valid looking IMEI if you added a $(luhn_checkdigit "35215209737497") to the end"

# Many credit card types also use this checksum
sample_mastercard="5105105105105100"
if luhn_test "$sample_mastercard"; then
	echo "$sample_mastercard might be a valid card number"
else
	echo "$sample_mastercard in an invalid card number"
fi

