<?php 
/* vim: set expandtab tabstop=4 softtabstop=4 shiftwidth=4:
  +----------------------------------------------------------------------+
  | Grandstream GXP21xx/GXP14xx/GXP116x IP Phone XML Phone Book Creator  |
  | For Elastix version 0.5 (maybe others) http://www.elastix.org        |
  +----------------------------------------------------------------------+
  | Made from 99% recycled code, applicable rights                       |
  | Palosanto Solutions S. A., Coalescent Systems Inc, FreePBX, et al.   |
  +----------------------------------------------------------------------+
  | The contents of this file are subject to the General Public License  |
  | (GPL) Version 2 (the "License"); you may not use this file except in |
  | compliance with the License. You may obtain a copy of the License at |
  | http://www.opensource.org/licenses/gpl-license.php                   |
  |                                                                      |
  | Software distributed under the License is distributed on an "AS IS"  |
  | basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See  |
  | the License for the specific language governing rights and           |
  | limitations under the License.                                       |
  +----------------------------------------------------------------------+ 
*/
header("Content-Type: text/xml");

define("AMP_CONF", "/etc/amportal.conf");

$file = file(AMP_CONF);
if (is_array($file)) {
    foreach ($file as $line) {
        if (preg_match("/^\s*([a-zA-Z0-9_]+)=([a-zA-Z0-9 .&-@=_!<>\"\']+)\s*$/",$line,$matches)) {
            $amp_conf[ $matches[1] ] = $matches[2];
        }
    }
}

require_once('DB.php'); //PEAR must be installed
$db_user = $amp_conf["AMPDBUSER"];
$db_pass = $amp_conf["AMPDBPASS"];
$db_host = $amp_conf["AMPDBHOST"];
$db_name = $amp_conf["AMPDBNAME"];

$datasource = 'mysql://'.$db_user.':'.$db_pass.'@'.$db_host.'/'.$db_name;
$db = DB::connect($datasource); // attempt connection

$type="getAll";
$results = $db->$type("SELECT extension,name,voicemail FROM users ORDER BY extension", null);
foreach($results as $result){
    $extensions[] = array($result[0],$result[1],$result[2]);
}

#$extensions = core_users_list();
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
echo "<AddressBook>\n";
$index = 0;
if (isset($extensions)) {
    foreach ($extensions as $key=>$extension) {
        $index= $index + 1;
        echo "\n\n\t<Contact>";
        echo "\n\t\t<LastName>" . $extension[1] . "</LastName>";
        echo "\n\t\t<FirstName></FirstName>";
        echo "\n\t\t<Phone>";
        echo "\n\t\t\t<phonenumber>" . $extension[0] . "</phonenumber>";
        echo "\n\t\t\t<accountindex>" . $index . "</accountindex>";
        echo "\n\t\t</Phone>";
        echo "\n\t</Contact>\n";
        echo('<br />');
    }
}
echo "</AddressBook>\n";

?>
